<?php
if (basename($_SERVER['PHP_SELF']) == basename(__FILE__)) {
    die('Direct access not allowed');
    exit();
  }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <link rel="stylesheet" href="https://toert.github.io/Isolated-Bootstrap/versions/4.0.0-beta/iso_bootstrap4.0.0min.css"></link>        
        <title>Ρυθμίσεις για προχωρημένους</title>
    </head>

    <body class="bootstrap">

        <div id="messageArea" style="display: none"></div>      
        
            <div class="alert alert-warning fade show">
                <h4 class="alert-heading"><i class="fa fa-warning"></i>Οδηγίες για προγραμματιστές</h4>
                <p>Τα API tokens χρησιμοποιούνται από άλλες υπηρεσίες για να μπορούν να αλληλεπιδράσουν με το loyalty σύστημα</p>
                <hr>
                <p class="mb-0">Τα tokens είναι μυστικά κλειδιά και δεν θα πρέπει να εκτίθονται σε κοινή θέα.</p>
                <p>Tο σύστημα αυθεντικοποίησης που χρησιμοποιείται είναι το Basic access authentication <p/>
                <p>οι κλήσεις προς το api θα πρέπει να παρέχουν ως http header <code>Authorization: Basic token</code> </p>
            </div>

        <?php if (!empty($apiUsers)) { ?>
            <table class="table table-hover table-dark">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Όνομα</th>
                        <th scope="col">Token</th>
                        <th scope="col">Ημερομηνία δημιουργίας</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $counter = 1;
                    foreach ($apiUsers as $apiUser) {
                        $token = base64_encode("{$apiUser->getName()}:{$apiUser->getPassword()}"); 
                        ?>
                        <tr>
                            <th scope="row">
                                <button type="button" class="btn btn-danger btn-sm" onclick="deleteApiUser(<?= $apiUser->getId() ?>)">
                                    <span class="glyphicon glyphicon-delete"></span> Διαγραφή
                                </button>    
                            </th>
                            <td hidden><input id="id<?= $counter ?>" name="id<?= $apiUser->getId() ?>" value="<?= $apiUser->getId() ?>"/></td>
                            <td><?= $apiUser->getName() ?></td>
                            <td style="word-break:break-all;"><?= $token ?></td>
                            <td><?= $apiUser->getCreationDate() ?></td>
                        </tr>
                        <?php
                        $counter++;
                    }
                    ?>
                </tbody>
                </table>
            <?php } else { ?>
                <div class="alert alert-info">
                    Δεν υπάρχουν API users
                </div>
            <?php } ?>
            <div class="container">
                <div class="row">
                    <div style="margin: auto; width: 50%;">

                        <p>
                            <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                                Προσθήκη API χρήστη
                            </button>
                        </p>
                        <div class="collapse" id="collapseExample">
                            <form action="api-user-save.php" method="POST" onsubmit="return formValidation()">

                                <div class="form-group">
                                    <label for="name">Όνομα</label>
                                    <input type="text" class="form-control" id="name" name="name" placeholder="Όνομα...">
                                        <small id="nameTextEmpty"   class="form-text text-muted" style="color:red; display: none">Δεν μπορεί να είναι άδειο</small>
                                        <small id="nameTextTooBig"   class="form-text text-muted" style="color:red; display: none">Δεν μπορεί να είναι μεγαλύερο των 80 χαρακτήρων</small>
                                        <small id="nameTextContainsIllegalChar"   class="form-text text-muted" style="color:red; display: none">Δεν μπορεί να περιέχει το σύμβολο :</small>
                                </div>
                                <div class="form-group" hidden>
                                    <input type="text" class="form-control" id="customerId" name="user_id" value="<?= $user_id ?>">
                                </div>

                                <input type="submit" class="btn btn-primary" value="Προσθήκη"/>
                            </form>

                        </div>
                    </div>
                </div>
            </div>



            <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
            <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
            <script type="text/javascript">
                window.onload = setTimeout(function () {
                    if (document.getElementById("messageArea"))
                        hideMe("messageArea");
                }, 3000);
                function hideMe(id) {
                    var x = document.getElementById(id);
                    x.style.display = "none";
                }

                function displayMe(id) {
                    var x = document.getElementById(id);
                    x.style.display = "block";
                }

                function formValidation() {
                    var name = document.getElementById("name").value;
                    if (name.includes(":")) {
                        displayDivAndHide("nameTextContainsIllegalChar", 3000);
                        return false;
                    }
                    if (name.length === 0) {
                        displayDivAndHide("nameTextEmpty", 3000);
                        return false;
                    }
                    if (name.length > 80) {
                        displayDivAndHide("nameTextTooBig", 3000);
                        return false;
                    }
                    return true;
                }

                function displayDivAndHide(div, time) {
                    displayMe(div);
                    setTimeout(function () {
                        hideMe(div);
                    }, time);
                }

                function deleteApiUser(id) {

                    if(!confirm("Είστε σίγουρος για την διαγραφή; Όποιος API χρήστης χρησιμοποιεί το token θα πάψει να έχει πρόσβαση ")) {
                        return;
                    }
                    var ajaxObject = initAjax();
                    ajaxObject.open("GET", "api-user-delete.php?id=" + id, false);
                    ajaxObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                    ajaxObject.send();
                    location.reload();
                }

                function initAjax() {
                    if (window.XMLHttpRequest) { // all modern browsers
                        return ajaxObject = new XMLHttpRequest();
                    } else if (window.ActiveXObject) { //for IE5, IE6
                        return ajaxObject = new ActiveXObject("Microsoft.XMLHTTP");
                    } else { //AJAX not supported
                        alert("Your browser does not support AJAX calls!");
                        return false;
                    }
                }
            </script>
            </body>
            </html>